*
* User-Toolset shell for Apple IIgs FakeModalDialog code
*
* David A. Lyons
*
* Developer Technical Support Apple II Sample Code
*
* v3.0  12-Mar-90  DAL
*
            case on

Version     gequ $0100                 ;v1.0

fmdUserTool start

            dc i4'(fmdEnd-fmdStart)/4+1'
fmdStart    dc i4'fNoError-1'           ;01xx fmdBootInit
            dc i4'fStartUp-1'           ;02xx fmdStartUp
            dc i4'fShutDown-1'          ;03xx fmdShutDown
            dc i4'fVersion-1'           ;04xx fmdVersion
            dc i4'fNoError-1'           ;05xx fmdReset
            dc i4'fStatus-1'            ;06xx fmdSTatus
            dc i4'fNoError-1'           ;07xx reserved
            dc i4'fNoError-1'           ;08xx reserved
            dc i4'fFakeMdlDlg-1'        ;09xx fakeModalDialog
            dc i4'fSetMenuProc-1'       ;0Axx fmdSetMenuProc
            dc i4'fGetMenuProc-1'       ;0Bxx fmdGetMenuProc
            dc i4'fmdStdDrawProc-1'     ;0Cxx fmdStdDrawProc*
            dc i4'fmdEditMenu-1'        ;0Dxx fmdEditMenu*
            dc i4'fFindCursCtl-1'       ;0Exx fmdFindCursorCtl
            dc i4'fSetText-1'           ;0Fxx fmdLESetText
            dc i4'fGetText-1'           ;10xx fmdLEGetText
            dc i4'fWhichRadio-1'        ;11xx fmdWhichRadio
            dc i4'fmdIBeamCursor-1'     ;12xx fmdIBeamCursor*
            dc i4'fmdInitIBeam-1'       ;13xx fmdInitIBeam*
            dc i4'fSetIBeam-1'          ;14xx fmdSetIBeam
            dc i4'fGetIBeamAdr-1'       ;15xx fmdGetIBeamAdr
            dc i4'fGetCtlPart-1'        ;16xx fmdGetCtlPart
            dc i4'fGetError-1'          ;17xx fmdGetCtlPart
fmdEnd      anop

*            
save6       lda >myStatus
            beq notStarted
            plx
            pla
            sta >temp
            pla
            sta >temp+2
            pla
            sta >temp+4
            phx
            rts

temp        ds  6

myStatus    ds  2

notStarted  pla                       ;discard return address
            txa
            xba
            and #$ff00
            ora #$8001
            sec
            rtl

fStartUp    jsl fmdStartUp
            lda #$ffff
            bra startStop

fShutDown   jsl fmdShutDown
            lda #$0000
startStop   sta >myStatus
fNoError    lda #0
            clc
            rtl

fVersion    lda #Version
            sta 7,s
            bra fNoError

fStatus     lda >myStatus
            sta 7,s
            bra fNoError

fFakeMdlDlg jsr save6
            jsl fakeModalDialog
            bra restore6

fSetMenuProc anop
            jsr save6
            jsl fmdSetMenuProc     ;Ahhhhh!!  We are falling.


restore6    tay                    ;This is here so everybody
            lda >temp+4            ;can reach it.
            pha
            lda >temp+2
            pha
            lda >temp
            pha
            tya
            rtl

            
fGetMenuProc anop
            jsr save6
            jsl fmdGetMenuProc
            bra restore6

fFindCursCtl anop
            jsr save6
            jsl fmdFindCursorCtl
            bra restore6

fSetText    jsr save6
            jsl fmdLESetText
            bra restore6

fGetText    jsr save6
            jsl fmdLEGetText
            bra restore6

fWhichRadio jsr save6
            jsl fmdWhichRadio
            bra restore6

fSetIBeam   jsr save6
            jsl fmdSetIBeam
            bra restore6

fGetIBeamAdr anop
            jsr save6
            jsl fmdGetIBeamAdr
            bra restore6

fGetCtlPart jsr save6
            jsl fmdGetCtlPart
            bra restore6

fGetError   jsr save6
            jsl fmdGetError
            bra restore6

            end
